<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WalletController extends Controller
{
    /**
     * Connect a wallet to the user's account
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function connect(Request $request)
    {
        $provider = $request->input('provider');
        $user = Auth::user();
        
        // Mark the wallet as connected and remove the requirement
        $user->is_wallet_connected = true;
        $user->require_wallet_connect = false;
        $user->save();
        
        return response()->json([
            'success' => true,
            'message' => 'Wallet connected successfully',
            'provider' => $provider,
        ]);
    }
} 