<?php $__env->startComponent('mail::message'); ?>
<?php if($type === 'submission'): ?>
# KYC Documents Received

Dear <?php echo e($user->name); ?>,

We have received your KYC (Know Your Customer) documents for verification. Thank you for submitting the required documentation.

<?php $__env->startComponent('mail::panel'); ?>
**Documents Received**
<?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc => $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
- <?php echo e(ucwords(str_replace('_', ' ', $doc))); ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

**Submission Date:** <?php echo e(now()->format('M d, Y H:i:s')); ?>

<?php echo $__env->renderComponent(); ?>

Our compliance team will review your documents within 24-48 hours. You will receive another email once the verification process is complete.

**Important Notes:**
- Please ensure all documents are clear and legible
- Documents must be valid and not expired
- All information should match your account details

<?php else: ?>
# KYC Verification <?php echo e(ucfirst($status)); ?>


Dear <?php echo e($user->name); ?>,

<?php if($status === 'approved'): ?>
Your KYC verification has been successfully completed and approved. Your account now has full access to all features.

<?php $__env->startComponent('mail::panel'); ?>
**Account Status:** Fully Verified
**Verification Date:** <?php echo e(now()->format('M d, Y H:i:s')); ?>


Your account now has access to:
- Unlimited crypto sending and receiving
- Full trading features and limits
- Complete platform functionality
- Referral bonus eligibility
<?php echo $__env->renderComponent(); ?>

<?php elseif($status === 'rejected'): ?>
Your KYC verification requires updates. Our compliance team has reviewed your submission and needs additional information.

<?php $__env->startComponent('mail::panel'); ?>
**Verification Status:** Update Required
**Review Date:** <?php echo e(now()->format('M d, Y H:i:s')); ?>


**Reason for Update Request:**
<?php echo e($rejectionReason ?? 'One or more submitted documents did not meet our verification requirements.'); ?>


**Common Requirements:**
- Documents must be clear and fully visible
- All text should be legible
- Documents should be current and valid
- Information must match your account details
<?php echo $__env->renderComponent(); ?>

Please submit updated documents through your KYC verification page. Ensure your new submission addresses the feedback provided above.

<?php else: ?>
Your KYC verification status has been updated to: <?php echo e(ucfirst($status)); ?>

<?php endif; ?>
<?php endif; ?>

<?php $__env->startComponent('mail::button', ['url' => route('kyc')]); ?>
View KYC Status
<?php echo $__env->renderComponent(); ?>

If you need assistance or have questions about the verification process, our support team is here to help at <?php echo e($supportEmail); ?>.

Best regards,  
<?php echo e($companyName); ?> Team
<?php echo $__env->renderComponent(); ?><?php /**PATH /home/blockcino/public_html/resources/views/emails/kyc.blade.php ENDPATH**/ ?>