<?php
    use App\Models\Transaction;
?>
<?php $__env->startComponent('mail::message'); ?>
<?php if($type === Transaction::TYPE_SWAP): ?>
# Crypto Swap Completed

Dear <?php echo e($transaction->user->name); ?>,

Your crypto swap has been completed successfully:

<?php $__env->startComponent('mail::panel'); ?>
**Swap Details**
- From: <?php echo e(number_format($amount_in, 8)); ?> <?php echo e($from_crypto); ?>

- To: <?php echo e(number_format($amount_out, 8)); ?> <?php echo e($to_crypto); ?>

- Rate: 1 <?php echo e($from_crypto); ?> = <?php echo e(number_format($rate, 8)); ?> <?php echo e($to_crypto); ?>

- USD Value: $<?php echo e(number_format($usd_value, 2)); ?>

- Date: <?php echo e($created_at ? $created_at->format('M d, Y H:i:s') : 'N/A'); ?>


**Prices at Time of Swap**
- <?php echo e($from_crypto); ?>: $<?php echo e(number_format($metadata['from_price_usd'], 2)); ?>

- <?php echo e($to_crypto); ?>: $<?php echo e(number_format($metadata['to_price_usd'], 2)); ?>

<?php echo $__env->renderComponent(); ?>

<?php else: ?>
# <?php echo e($type === 'deposit' ? 'Crypto Received' : 'Crypto Sent'); ?>


Dear <?php echo e($transaction->user->name); ?>,

Your crypto transaction has been <?php echo e($status === 'completed' ? 'completed' : 'processed'); ?>:

<?php $__env->startComponent('mail::panel'); ?>
**Transaction Details**
- Amount: <?php echo e(number_format($amount, 8)); ?> <?php echo e($crypto); ?>

- Status: <?php echo e(ucfirst($status)); ?>

- Date: <?php echo e($created_at ? $created_at->format('M d, Y H:i:s') : 'N/A'); ?>

<?php if($network): ?>
- Network: <?php echo e($network); ?>

<?php endif; ?>

<?php if($type === 'withdrawal' && isset($metadata['network_fee'])): ?>
- Network Fee: <?php echo e(number_format($metadata['network_fee'], 8)); ?> <?php echo e($crypto); ?>

<?php endif; ?>

<?php if($type === 'withdrawal' && isset($metadata['external_address'])): ?>
**Recipient Address**  
<?php echo e($metadata['external_address']); ?>

<?php if(isset($metadata['transaction_hash'])): ?>
**Transaction Hash**  
<?php echo e($metadata['transaction_hash']); ?>

<?php endif; ?>
<?php endif; ?>

<?php if($type === 'withdrawal' && isset($metadata['recipient_name'])): ?>
**Sent To**  
<?php echo e($metadata['recipient_name']); ?> (PayID: <?php echo e($metadata['recipient_payid']); ?>)
<?php endif; ?>

<?php if($type === 'deposit' && isset($metadata['sender_name'])): ?>
**Received From**  
<?php echo e($metadata['sender_name']); ?> (PayID: <?php echo e($metadata['sender_payid']); ?>)
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

If you did not initiate this transaction or notice any suspicious activity, please contact our support team immediately at <?php echo e($supportEmail); ?>.

Best regards,  
<?php echo e($companyName); ?> Team
<?php echo $__env->renderComponent(); ?><?php /**PATH /home/blockcino/public_html/resources/views/emails/transaction.blade.php ENDPATH**/ ?>