<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="md:pb-4 bg-gray-100 text-black dark:bg-gray-900 dark:text-white transition-all duration-300">
        <div class="flex items-center justify-between mb-6">
            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-400 dark:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <div class="text-center">
                <h1 class="text-2xl font-bold"><?php echo e($asset['symbol']); ?></h1>
                <?php if($asset['network']): ?>
                    <p class="text-gray-400 dark:text-gray-400"><?php echo e($asset['symbol']); ?> | <?php echo e($asset['network']); ?></p>
                <?php else: ?>
                    <p class="text-gray-400 dark:text-gray-400"><?php echo e($asset['symbol']); ?> | <?php echo e(ucfirst($coinId)); ?></p>
                <?php endif; ?>
            </div>
            <button class="text-gray-400 dark:text-white">
                <i class="fas fa-chart-line text-xl"></i>
            </button>
        </div>

        <div class="flex justify-center my-8">
            <div class="relative">
                <?php if($asset['icon_url']): ?>
                    <img src="<?php echo e($asset['icon_url']); ?>" alt="<?php echo e($asset['symbol']); ?>" class="w-24 h-24 rounded-full">
                    <?php if(!empty($asset['network_url'])): ?>
                        <img src="<?php echo e($asset['network_url']); ?>" 
                             alt="<?php echo e($asset['network']); ?>" 
                             class="absolute border border-light" 
                             style="width: 24px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                    <?php endif; ?>
                <?php else: ?>
                    <div class="w-24 h-24 bg-gray-300 dark:bg-gray-700 rounded-full flex items-center justify-center">
                        <span class="text-2xl"><?php echo e($asset['symbol']); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold mb-2"><?php echo e(number_format($asset['balance'], 8)); ?> <?php echo e($asset['symbol']); ?></h2>
            <p class="text-gray-500 dark:text-gray-300">$<?php echo e(number_format($asset['value'], 2)); ?></p>
        </div>

        <div class="mt-8 grid mb-8 grid-cols-4 gap-4">
            <div class="flex flex-col items-center">
                <button onclick="openAssetSendModal()" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center justify-center">
                    <i class="fas fa-arrow-up text-xl dark:text-white"></i>
                </button>
                <span class="mt-2 text-sm dark:text-gray-400">Send</span>
            </div>
            <div class="flex flex-col items-center">
                <button onclick="openAssetReceiveModal()" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center justify-center">
                    <i class="fas fa-arrow-down text-xl dark:text-white"></i>
                </button>
                <span class="mt-2 text-sm dark:text-gray-400">Receive</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="<?php echo e(route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center justify-center">
                    <i class="fas fa-credit-card text-xl dark:text-white"></i>
                </a>
                <span class="mt-2 text-sm dark:text-gray-400">Buy</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="<?php echo e(route('swap')); ?>" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center justify-center">
                    <i class="fas fa-exchange-alt text-xl dark:text-white"></i>
                </a>
                <span class="mt-2 text-sm dark:text-gray-400">Swap</span>
            </div>
        </div>

        <div class="text-center mb-8">
            <h3 class="text-xl border-b-2 md:mr-[465px] md:ml-[465px] mr-[130px] ml-[130px] mb-[-1px] border-gray-900 dark:border-white font-semibold mb-4">Transactions</h3>
        </div>

        <!-- Transaction List -->
<div class="space-y-4">
    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-lg mb-4">
        <div class="flex items-center">
            <?php
                $currentCrypto = strtolower($asset['symbol']);
                if ($asset['network']) {
                    $currentCrypto = strtolower($asset['symbol']) . '_' . strtolower($asset['network']);
                }
                
                // Check if this is a funding transaction
                if ($transaction->type === 'funding') {
                    $isIncoming = false;
                    $amount = $transaction->amount_out;
                }
                // Check for swap transactions
                elseif ($transaction->type === 'swap') {
                    $isIncoming = $transaction->to_crypto === $currentCrypto;
                    $amount = $isIncoming ? $transaction->amount_out : $transaction->amount_in;
                }
                // For other transaction types
                else {
                    $isIncoming = in_array($transaction->type, ['deposit', 'refund']);
                    $amount = $isIncoming ? $transaction->amount_in : $transaction->amount_out;
                }
                
                // Set icon and color based on status
                if ($transaction->status === 'pending') {
                    $iconClass = 'bg-yellow-500';
                    $iconDirection = 'fa-spinner';
                    $amountPrefix = '';
                    $amountClass = 'text-yellow-500';
                } else {
                    $iconClass = $isIncoming ? 'bg-green-500' : 'bg-red-500';
                    $iconDirection = $isIncoming ? 'fa-arrow-down' : 'fa-arrow-up';
                    $amountPrefix = $isIncoming ? '+' : '-';
                    $amountClass = $isIncoming ? 'text-green-500' : 'text-red-500';
                }

                // Format display names for swaps
                $fromCryptoDisplay = strtoupper(explode('_', $transaction->from_crypto)[0]);
                $toCryptoDisplay = strtoupper(explode('_', $transaction->to_crypto)[0]);
                if (strpos($transaction->from_crypto, '_') !== false) {
                    $networkFrom = explode('_', $transaction->from_crypto)[1];
                    $fromCryptoDisplay .= ' ' . strtoupper($networkFrom);
                }
                if (strpos($transaction->to_crypto, '_') !== false) {
                    $networkTo = explode('_', $transaction->to_crypto)[1];
                    $toCryptoDisplay .= ' ' . strtoupper($networkTo);
                }
            ?>
            
            <div class="w-10 h-10 <?php echo e($iconClass); ?> rounded-full flex items-center justify-center mr-4">
                <i class="fas <?php echo e($iconDirection); ?> text-white"></i>
            </div>
            <div>
                <h3 class="font-semibold">
                    <?php if($transaction->type === 'funding'): ?>
                        Funded Card
                    <?php elseif($transaction->type === 'swap'): ?>
                        <?php if($isIncoming): ?>
                            Swapped from <?php echo e($fromCryptoDisplay); ?>

                        <?php else: ?>
                            Swapped to <?php echo e($toCryptoDisplay); ?>

                        <?php endif; ?>
                    <?php else: ?>
                        <?php echo e(ucfirst($transaction->type)); ?>

                    <?php endif; ?>
                </h3>
                <p class="text-sm text-gray-800 dark:text-gray-400">
                    <?php echo e($transaction->created_at->format('M d, Y')); ?>

                </p>
            </div>
        </div>
        <div class="text-right">
            <p class="<?php echo e($amountClass); ?>">
                <?php echo e($amountPrefix); ?><?php echo e(number_format($amount, 6)); ?> <?php echo e($asset['symbol']); ?>

            </p>
            <?php if(isset($transaction->metadata['usd_value'])): ?>
                <p class="text-sm text-gray-800 dark:text-gray-400">
                    $<?php echo e(number_format($transaction->metadata['usd_value'], 2)); ?>

                </p>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="text-center py-8">
        <p class="text-gray-500 dark:text-gray-400 mb-4">No transactions yet</p>
        <button wire:navigate href="<?php echo e(route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                class="bg-yellow-500 text-black font-bold py-3 px-8 rounded-lg hover:bg-yellow-600 dark:bg-yellow-400 dark:text-black">
            Buy <?php echo e($asset['symbol']); ?>

        </button>
    </div>
<?php endif; ?>
</div>


        <!-- Send Modal -->
        <div id="assetSendModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-gray-100 dark:bg-gray-800 w-full md:w-96 md:rounded-lg mt-auto sm:mt-24 relative">
                <div class="flex items-center justify-between p-4 border-b border-gray-100 dark:border-gray-800">
                    <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Send <?php echo e($asset['symbol']); ?></h2>
                    <button onclick="closeAssetSendModal()" class="text-gray-400 hover:text-gray-300 dark:text-gray-400 dark:hover:text-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="p-4 space-y-4">
                    <a href="<?php echo e(route('send.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                        class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left block">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-500 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-shield-alt text-black"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-yellow-500">Send via Ledger Chain PayId</h3>
                                <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Send coins from Ledger Chain to Ledger Chain fast and free. No network fee</p>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('send.external.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                        class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left block">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-500 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-coins text-white"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-800 dark:text-white">Send via <?php echo e($asset['symbol']); ?></h3>
                                <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Send coins from your Ledger Chain crypto wallet. Network fees included</p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Receive Modal -->
        <div id="assetReceiveModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-gray-100 dark:bg-gray-800 w-full md:w-96 md:rounded-lg mt-auto sm:mt-24 relative">
                <div class="flex items-center justify-between p-4 border-b border-gray-100 dark:border-gray-800">
                    <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Receive <?php echo e($asset['symbol']); ?></h2>
                    <button onclick="closeAssetReceiveModal()" class="text-gray-400 hover:text-gray-300 dark:text-gray-400 dark:hover:text-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="p-4 space-y-4">
                    <a href="<?php echo e(route('receive.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                        class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left block">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-500 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-shield-alt text-black"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-yellow-500">Receive via Ledger Chain PayId</h3>
                                <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Receive coins from Ledger Chain to Ledger Chain fast and free. No network fee</p>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('receive.external.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                        class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left block">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-500 rounded-full flex items-center justify-center mr-4">
                                <i class="fas fa-coins text-white"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-800 dark:text-white">Receive via <?php echo e($asset['symbol']); ?></h3>
                                <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Receive coins from your Ledger Chain crypto wallet. Network fees included</p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <?php $__env->startPush('scripts'); ?>
        <script>
            function openAssetSendModal() {
                document.getElementById('assetSendModal').classList.remove('hidden');
            }

            function closeAssetSendModal() {
                document.getElementById('assetSendModal').classList.add('hidden');
            }

            function openAssetReceiveModal() {
                document.getElementById('assetReceiveModal').classList.remove('hidden');
            }

            function closeAssetReceiveModal() {
                document.getElementById('assetReceiveModal').classList.add('hidden');
            }

            // Close modals when clicking outside
            window.addEventListener('click', function(event) {
                const sendModal = document.getElementById('assetSendModal');
                const receiveModal = document.getElementById('assetReceiveModal');

                if (event.target === sendModal) {
                    sendModal.classList.add('hidden');
                }

                if (event.target === receiveModal) {
                    receiveModal.classList.add('hidden');
                }
            });
        </script>
        <?php $__env->stopPush(); ?>
    </main>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/cypherva/public_html/resources/views/user/crypto/details.blade.php ENDPATH**/ ?>